/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <chrono>
#include <iostream>
#include <iomanip>

template <typename C>
void printClockData ()
{
    using namespace std;

    cout << "- precyzja: ";
    // jeśli jednostka czasu jest krótsza lub równa jednej milisekundzie
    typedef typename C::period P;   // typ jednostki czasu
    if (ratio_less_equal<P,milli>::value) {
        // zamiana na milisekundy
        typedef typename ratio_multiply<P,kilo>::type TT;
        cout << fixed << double(TT::num)/TT::den
             << " milisekundy" << endl;
    }
    else {
        // zamiana na sekundy
        cout << fixed << double(P::num)/P::den << " sekundy" << endl;
    }
    cout << "- miarowość: " << boolalpha << C::is_steady << endl;
}
