/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <chrono>
#include <ctime>
#include <iostream>
#include <string>
using namespace std;

string asString (const chrono::system_clock::time_point& tp)
{
    time_t t = chrono::system_clock::to_time_t(tp); // konwersja na czas systemowy
    string ts = ctime(&t);                          // konwersja na czas kalendarzowy
    ts.resize(ts.size()-1);                         // wycięcie znaku nowego wiersza na końcu
    return ts; 
}

int main()
{
    // definicja typu dla okresów reprezentujących dni:
    typedef chrono::duration<int,ratio<3600*24>> Days;

    // pobierz epokę zegara systemowego
    chrono::time_point<chrono::system_clock> tp;
    cout << "epoka:     " << asString(tp) << endl;

    // dodaj jeden dzień, 23 godziny i 55 minut
    tp += Days(1) + chrono::hours(23) + chrono::minutes(55);
    cout << "później:     " << asString(tp) << endl;

    // wyznacz różnicę do epoki, w minutach i dniach:
    auto diff = tp - chrono::system_clock::time_point();
    cout << "różnica:      "
         << chrono::duration_cast<chrono::minutes>(diff).count()
         << " minut" << endl;
    Days days = chrono::duration_cast<Days>(diff);
    cout << "różnica:      " << days.count() << " dni" << endl;

    // odejmij jeden rok
    tp -= chrono::hours(24*365);
    cout << "-1 rok:   " << asString(tp) << endl;

    // odejmij 50 lat (z grubsza, bez uwzględniania lat przestępnych)
    tp -= chrono::duration<int,ratio<3600*24*365>>(50);
    cout << "-50 lat: " << asString(tp) << endl;

    // odejmij kolejne 50 lat
    tp -= chrono::duration<int,ratio<3600*24*365>>(50);
    cout << "-50 lat: " << asString(tp) << endl;
}
