/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <locale>
#include <string>
#include <iostream>
#include <exception>
#include <cstdlib>
#include "wstring2string.hpp"
#include "wstring2utf8.hpp"

int main()
{
    try {
#ifdef _MSC_VER
        // łańcuch z niemiecką literą i symbolem euro (w kodowaniu Windows):
        std::string s = "nj: ä + \x80 1";
        // zamieniany na łańcuch znaków szerokiego zestawu (w kodowaniu Windows):
        std::wstring ws = to_wstring(s,std::locale("deu_DEU.1252"));
#else
        // łańcuch z niemiecką literą i symbolem euro (w kodowaniu ISO Latin-15):
        std::string s = "nj: ä + \xA4 1";
        // zamieniany na łańcuch znaków szerokiego zestawu (w kodowaniu ISO Latin-15):
        std::wstring ws = to_wstring(s,std::locale("de_DE.ISO-8859-15"));
#endif

        // wypisanie łańcucha jako sekwencji UTF-8:
        std::cout << wstring_to_utf8(ws) << std::endl;
    }
    catch (const std::exception& e) {
        std::cerr << "WYJĄTEK: " << e.what() << std::endl;
        return EXIT_FAILURE;
    }
}
