/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <stack>
using namespace std;

int main()
{
    stack<int> st;

    // odłóż na stos trzy elementy
    st.push(1);
    st.push(2);
    st.push(3);
    // pobierz ze stosu dwa elementy i je wypisz
    cout << st.top() << ' ';
    st.pop();
    cout << st.top() << ' ';
    st.pop();

    // zmień kolejny element
    st.top() = 77;

    // umieść dwa dodatkowe elementy
    st.push(4);
    st.push(5);

    // pobierz jeden element bez jego przetwarzania
    st.pop();

    // pobierz i wypisz pozostałe elementy
    while (!st.empty()) {
        cout << st.top() << ' ';
        st.pop();
    }
    cout << endl;
}
