/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <tuple>
#include <iostream>
#include <complex>
#include <string>
using namespace std;

int main()
{
    // tworzy krotkę czteroelementową
    // - elementy są inicjalizowane wartościami domyślnymi (0 w przypadku typów podstawowych)
    tuple<string,int,int,complex<double>> t;

    // jawne utworzenie i zainicjalizowanie krotki
    tuple<int,float,string> t1(41,6.3,"janek");

    // "przeglądanie" elementów krotki:
    cout << get<0>(t1) << " ";
    cout << get<1>(t1) << " ";
    cout << get<2>(t1) << " ";
    cout << endl;

    // tworzenie krotki wywołaniem make_tuple()
    // - słowo auto zastępuje deklarację typu t2 po prawej stronie
    // - typ t2 to tuple
    auto t2 = make_tuple(22,44,"janek");

    // przypisanie drugiej wartości z t2 do odpowiedniej wartości z t1
    get<1>(t1) = get<1>(t2);

    // porównywanie i przypisywania
    // - z konwersją typu z tuple<int,int,const char*> na tuple<int,float,string> włącznie
    if (t1 < t2) { // porównanie wartości do wartości
        t1 = t2;   // OK, przypisanie wartości do wartości
    }
}
