/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <set>
#include <algorithm>
#include <iterator>
#include <iostream>
using namespace std;

int main()
{
    // zbiór nieporządkujący z elementami od 1 do 9
    set<int> coll = { 1, 2, 3, 4, 5, 6, 7, 8, 9 };

    // wypisz wszystkie elementy kolekcji
    copy (coll.cbegin(), coll.cend(),
          ostream_iterator<int>(cout," "));
    cout << endl;

    // usuń wszystkie elementy o wartości 3
    // - nie działa algorytm remove()
    // - działa za to funkcja składowa erase()
    int num = coll.erase(3);

    // wypisz liczbę usuniętych elementow
    cout << "liczba usuniętych elementów: " << num << endl;

    // wypisz wszystkie elementy zmodyfikowanej kolekcji
    copy (coll.cbegin(), coll.cend(),
          ostream_iterator<int>(cout," "));
    cout << endl;
}
