/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <map>
#include <iostream>
#include <algorithm>
#include <utility>
using namespace std;

int main()
{
    // mapa z elementami typu float jako klucze i wartości
    // - inicjalizacja powoduje automatyczną zamianę kluczy i wartości na typ float
    map<float,float> coll = { {1,7}, {2,4}, {3,2}, {4,3},
                              {5,6}, {6,1}, {7,3} };

    // wyszukanie elementu o kluczu 3.0 (złożoność logarytmiczna)
    auto posKey = coll.find(3.0);
    if (posKey != coll.end()) {
        cout << "znaleziono klucz 3.0 ("
             << posKey->first << ":"
             << posKey->second << ")" << endl;
    }

    // wyszukanie elementu o wartości 3.0 (złożoność liniowa)
    auto posVal = find_if(coll.begin(),coll.end(),
                          [] (const pair<float,float>& elem) {
                              return elem.second == 3.0;
                          });
    if (posVal != coll.end()) {
        cout << "znaleziono wartość 3.0 ("
             << posVal->first << ":"
             << posVal->second << ")" << endl;
    }
}
