/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <future>
#include <thread>
#include <chrono>
#include <random>
#include <iostream>
#include <exception>
using namespace std;

void doSomething (char c)
{
    // generator liczb losowych (wykorzystuje c jako ziarno do uzyskania różnych sekwencji)
    default_random_engine dre(c);
    uniform_int_distribution<int> id(10,1000);

    // pętla wyświetlająca znak po upływie losowego czasu 
    for (int i=0; i<10; ++i) {
        this_thread::sleep_for(chrono::milliseconds(id(dre)));
        cout.put(c).flush();
    }
}

int main()
{
    cout << "uruchomienie 2 zadań asynchronicznie" << endl;

    // uruchomienie dwóch pętli w tle wyświetlających znaki . lub +.
    auto f1 = async([]{ doSomething('.'); });
    auto f2 = async([]{ doSomething('+'); });

    // jeśli działa co najmniej jedno zadanie realizowane w tle
    if (f1.wait_for(chrono::seconds(0)) != future_status::deferred ||
        f2.wait_for(chrono::seconds(0)) != future_status::deferred) {
        // odpytywanie do czasu zakończenia co najmniej jednej pętli
        while (f1.wait_for(chrono::seconds(0)) != future_status::ready &&
               f2.wait_for(chrono::seconds(0)) != future_status::ready) {
            ///...;
            this_thread::yield(); // wskazówka przekazania sterowania do następnego wątku
        }
    }
    cout.put('\n').flush();

    // oczekiwanie na zakończenie wszystkich pętli i przetwarzanie wyjątków
    try {
        f1.get();
        f2.get();
    }
    catch (const exception& e) {
        cout << "\nWYJĄTEK: " << e.what() << endl;
    }
    cout << "\nzrobione" << endl;
}
