/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include <iostream>
#include <algorithm>
#include <iterator>

using namespace std;

bool bothSpaces (char elem1, char elem2)
{
    return elem1 == ' ' && elem2 == ' ';
}

int main()
{
    // nie pomijaj domyslnie poczatkowych znakow spacji
    cin.unsetf(ios::skipws);

    // kopiuj wejscie standardowe na wyjscie standardowe
    // - z kompresja znakow spacji
    unique_copy(istream_iterator<char>(cin),  // poczatek zrodla: cin
                istream_iterator<char>(),     // koniec zrodla: koniec pliku
                ostream_iterator<char>(cout), // przeznaczenie: cout
                bothSpaces);                  // kryterium powtorzenia
}
