/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
   deque<int> coll;

   coll = { 1, 2, 7, 7, 6, 3, 9, 5, 7, 7, 7, 3, 6 };
   PRINT_ELEMENTS(coll);

   // znajdź trzy kolejne elementy o wartości 7
   deque<int>::iterator pos;
   pos = search_n (coll.begin(), coll.end(),    // zakres
                   3,                           // liczba elementów
                   7);                          // wartość

   // wypisz wynik
   if (pos != coll.end()) {
       cout << "trzy kolejne elementy o wartości 7 "
            << "występują na pozycjach począwszy od "
            << distance(coll.begin(),pos) +1
            << ". elementu" << endl;
   }
   else {
       cout << "nie znaleziono trzech kolejnych elementów o wartości 7"
            << endl;
   }

   // znajdź cztery kolejne elementy nieparzyste
   pos = search_n (coll.begin(), coll.end(),    // zakres
                   4,                           // liczba elementów
                   0,                           // wartość
                   [](int elem, int value){     // kryterium
                       return elem%2==1;
                   });

   // wypisz wynik
   if (pos != coll.end()) {
       cout << "cztery kolejne elementy o wartościach nieparzystych to: ";
       for (int i=0; i<4; ++i, ++pos) {
            cout << *pos << ' ';
       }
   }
   else {
       cout << "nie znaleziono czterech kolejnych elementów "
            << "o wartościach nieparzystych";
   }
   cout << endl;
}
