/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
    vector<int> coll;

    INSERT_ELEMENTS(coll,2,6);
    INSERT_ELEMENTS(coll,4,9);
    INSERT_ELEMENTS(coll,1,7);
    PRINT_ELEMENTS(coll,"coll:                  ");

    // usun wszystkie elementy o wartosci 5
    vector<int>::iterator pos;
    pos = remove(coll.begin(), coll.end(),   // zakres
                 5);                         // wartosc do usuniecia

    PRINT_ELEMENTS(coll,"niezmieniony rozmiar:  ");

    // wymaz "usuniete" elementy z kontenera
    coll.erase(pos, coll.end());
    PRINT_ELEMENTS(coll,"zmieniony rozmiar:     ");

    // usun wszystkie elementy mniejsze od 4
    coll.erase(remove_if(coll.begin(), coll.end(),  // zakres
                         [](int elem) {            // kryterium usuniecia
                             return elem<4;
                         }),
               coll.end());
    PRINT_ELEMENTS(coll,"usunieto elementy <4:  ");
}
