/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
   vector<int> coll1;
   vector<int> coll2;

   INSERT_ELEMENTS(coll1,1,9);
   INSERT_ELEMENTS(coll2,1,9);
   PRINT_ELEMENTS(coll1,"coll1: ");
   PRINT_ELEMENTS(coll2,"coll2: ");
   cout << endl;

   // przenieś wszystkie parzyste elementy na przód
   vector<int>::iterator pos1, pos2;
   pos1 = partition(coll1.begin(), coll1.end(),          // zakres
                    [](int elem){                        // kryterium
                        return elem%2==0;
                    });
   pos2 = stable_partition(coll2.begin(), coll2.end(),  // zakres
                           [](int elem){                // kryterium
                               return elem%2==0;
                           });

   // wypisz kolekcje i pierwszy nieparzysty element
   PRINT_ELEMENTS(coll1,"coll1: ");
   cout << "pierwszy nieparzysty element: " << *pos1 << endl;
   PRINT_ELEMENTS(coll2,"coll2: ");
   cout << "pierwszy nieparzysty element: " << *pos2 << endl;
}
