/* The following code example is taken from the book
 * "The C++ Standard Library - A Tutorial and Reference, 2nd Edition"
 * by Nicolai M. Josuttis, Addison-Wesley, 2012
 *
 * (C) Copyright Nicolai M. Josuttis 2012.
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 */
#include "algostuff.hpp"
using namespace std;

int main()
{
    vector<int> coll1 = { 1, 2, 3, 4, 5, 6 };
    list<int>   coll2 = { 1, 2, 4, 8, 16, 3 };

    PRINT_ELEMENTS(coll1,"coll1: ");
    PRINT_ELEMENTS(coll2,"coll2: ");

    // znajdź pierwszą niezgodność
    auto values = mismatch (coll1.cbegin(), coll1.cend(),  // pierwszy zakres
                            coll2.cbegin());               // drugi zakres
    if (values.first == coll1.end()) {
        cout << "brak niezgodności" << endl;
    }
    else {
        cout << "pierwsza niezgodność: "
             << *values.first  << " oraz "
             << *values.second << endl;
    }

    // znajdź pierwszą pozycję, gdzie element kolekcji coll1 nie jest
    // mniejszy od odpowiadającego mu elementu kolekcji coll2
    values = mismatch (coll1.cbegin(), coll1.cend(),       // pierwszy zakres
                       coll2.cbegin(),                     // drugi zakres
                       less_equal<int>());                 // kryterium
    if (values.first == coll1.end()) {
        cout << "zawsze mniejsze lub równe" << endl;
    }
    else {
        cout << "nie mniejszy lub równy: "
             << *values.first << " oraz "
             << *values.second << endl;
    }
}
