<?php
	// ze względu na to, iż plik index.php ma już include ("config.php") 
	// to plik w game.php będzie też obecny! Ponieważ index.php ma include ("game.php")
	// ale gdy będziemy wczytywać plik przy pomocy AJAX (game.js)
	// musimy znowu załadować plik "config.php" ponieważ ładujemy tylko samo game.php bez index.php
	// dlatego używamy require_once który sprawdza czy plik został już załączony "config.php"
	include ("config.php");

	$game=mysqli_fetch_array(mysqli_query($link, "SELECT * FROM `game_sessions` WHERE session_key='".$_GET['session']."'"));
		
	$array = json_decode($game['grid'], false);
	
	// SPRAWDZAMY RZĘDY W TABLICY KTO WYGRAŁ 
	// Kółko = 2
	// Krzyżyk = 1
	// Puste pole = 0
	// Przykładowe zwycięstwo "kółka" po skosie, nasza tablica:
	// [2][1][0]
	// [0][2][1]
	// [0][0][2]
	
	// kto wygrał?
	$win = ["x"=>false, "o"=>false];
	
	// pionowo
	for($h = 0; $h<3; $h++){
		$count = ["x"=>0, "o"=>0];
		for($x = 0; $x<3; $x++){
			if($array[$h][$x]==1) $count["x"]++;
			if($array[$h][$x]==2) $count["o"]++;
		}
		if($count["x"]==3){
			$win["x"]=true; 
			break; // przerwij pętle
		}
		
		if($count["o"]==3){
			$win["o"]=true;
			break;
		}
	}
	
	// poziomo
	for($v = 0; $v<3; $v++){
		$count = ["x"=>0, "o"=>0];
		for($y = 0; $y<3; $y++){
			if($array[$y][$v]==1) $count["x"]++;
			if($array[$y][$v]==2) $count["o"]++;
		}
		if($count["x"]==3){
			$win["x"]=true;
			break;
		}
		
		if($count["o"]==3){
			$win["o"]=true;
			break;
		}
	}
	// skosy
	if($array[0][0]==1 && $array[1][1]==1 && $array[2][2]==1){
		$win["x"]=true;
	}else if($array[0][0]==2 && $array[1][1]==2 && $array[2][2]==2){  
		$win["o"]=true;
	}
	
	if($array[0][2]==1 && $array[1][1]==1 && $array[2][0]==1){ 
		$win["x"]=true;
	}else if($array[2][0]==2 && $array[1][1]==2 && $array[2][0]==2){  
		$win["o"]=true;
	}
	
	// jeśli wygrana X albo O
	if($win["o"]){
		echo 'Wygrywa kółko';
		echo '<BR><BR>';
	}else if($win["x"]){
		echo 'Wygrywa krzyżyk';
		echo '<BR><BR>';
	}
	
	// jeśli sesja została usunięta w SQL $game będzie puste, więc nie wyświetlaj naszej gry (tablicy)
	if(!empty($game)){
		switch($_GET['w']){
			case ('move'):
				// jeśli $_SESSION['kolko_czy_krzyzk'] ma inną wartość niż game['current'], która zmienia się
				// gdy wykonujemy "ruch", dzięki temu inny gracz nie może klikać, musi czekać na ruch drugiego gracza
				// oraz jeśli nie ma zwycięzcy
				if($win["x"]==false AND $win["o"]==false && $_SESSION['kolko_czy_krzyzk']!=$game['current']){
					// pobieramy pozycję jaką gracz wybrał ze zmiennej $_GET 
					$gridPos = explode(',', $_GET['p']);
					// $_SESSION mamy zapisany czy gracz używa O albo X
					$array[$gridPos[0]][$gridPos[1]] = $_SESSION['kolko_czy_krzyzk']; 
					// zapisujemy w formacie JSON (prosty format danych)
					$json = json_encode($array);
					// całość aktualizujemy do bazy 
					mysqli_query($link, "UPDATE `game_sessions` SET current='".$_SESSION['kolko_czy_krzyzk']."', grid='$json' WHERE session_key ='$_GET[session]'");			
				}
			break;
			
			default:
				// informacja o tym kto ma ruch pod warunkiem, że 
				// nie ma wygranego 
				if($win["x"]==false AND $win["o"]==false){
					if($game['current']==1) echo 'Ruch ma gracz O. '; else echo 'Ruch ma gracz X. ';
				
					// sprawdzamy kto ma ruch i wyświetlamy informacje
					if($_SESSION['kolko_czy_krzyzk']!=$game['current']) echo 'Czyli Ty!'; else echo 'Czekam na ruch gracza...';
				
					echo '<BR><BR>';
				}
				
				for($y = 0; $y<count($array); $y++){
					for($x = 0; $x<count($array[$y]); $x++){
						// po kliknięciu na "PUSTE POLE" wysyłamy za pomocą funkcji sendData (game.js) współrzędne x/y które 
						// są odbierane w SWITCH -> case('move') gdzie x/y jest zapisywany w bazie SQL
						echo '<div onclick="sendData(\'game.php?session='.$_GET['session'].'&w=move&p='.$y.','.$x.'\', true, true);" title="y: '.$y.', x: '.$x.'" style="cursor: pointer; position: relative; width: 100px; height: 100px; outline: 1px solid; float: left;">';
						
						// nasze puste "bloki"
						echo '<div style="position: absolute; left:50%; top:50%; transform: translate(-50%, -50%);">';
						// wyświetl informacje o kliknięciu gdy jest ruch gracza
						if($array[$y][$x]==0 && $game['current']!=$_SESSION['kolko_czy_krzyzk']) echo '(kliknij)';
						if($array[$y][$x]==1) echo 'X';
						if($array[$y][$x]==2) echo 'O';
						echo '</div>';
						echo '</div>';
					}
					// gdy wyświetlone są 3 kwadraty dodaj "ENTER" (break line),
					// aby następne były rysowane w następnym rzędzie
					if($x % 3 == 0) echo '<BR>';
				}
			break;
		}
	}else{
		echo 'Sesja nie istnieje lub została usunięta!';
	}
?>