package uk.co.danielbryant.shopping.productcatalogue.model.v2;

import java.math.BigDecimal;

import static com.github.quiram.utils.ArgumentChecks.ensure;
import static com.github.quiram.utils.ArgumentChecks.ensureNotNull;

public class Price {
    private UnitPrice single;
    private BulkPrice bulkPrice;

    public Price() {

    }

    public Price(UnitPrice single, BulkPrice bulkPrice) {
        ensureNotNull(single, "single price");
        ensure(() -> bulkPrice == null || bulkPriceLowerThanSinglePrice(bulkPrice, single),
                "Cena hurtowa musi być niższa niż detaliczna lub nie może jej tam być");

        this.single = single;
        this.bulkPrice = bulkPrice;
    }

    private static boolean bulkPriceLowerThanSinglePrice(BulkPrice bulkPrice, UnitPrice singlePrice) {
        return bulkPrice.getUnit().compareTo(singlePrice) < 0;
    }

    public static Price singlePrice(int singlePrice) {
        return new Price(new UnitPrice(singlePrice), null);
    }

    public static Price singlePrice(String singlePrice) {
        return new Price(new UnitPrice(new BigDecimal(singlePrice)), null);
    }

    public static Price complexPrice(String singlePrice, String bulkPrice, int bulkMinAmount) {
        return new Price(new UnitPrice(new BigDecimal(singlePrice)), new BulkPrice(new UnitPrice(new BigDecimal(bulkPrice)), bulkMinAmount));
    }

    public UnitPrice getSingle() {
        return single;
    }

    public void setSingle(UnitPrice single) {
        this.single = single;
    }

    public BulkPrice getBulkPrice() {
        return bulkPrice;
    }

    public void setBulkPrice(BulkPrice bulkPrice) {
        this.bulkPrice = bulkPrice;
    }
}
