$dbRG = 'MojaGrupaZasobow';
$dbServer = 'mojserwerbazydanych';
$server = Set-AzureRmSqlServer -ResourceGroupName $dbRG -ServerName $dbServer -AssignIdentity

$KeyVaultName = 'MojMagazynKluczy';
Set-AzureRmKeyVaultAccessPolicy -VaultName $KeyVaultName -ObjectId $server.Identity.PrincipalId -PermissionsToKeys get, wrapKey, unwrapKey

$keyEncryptionKeyName = 'MojKlucz';
$keyEncryptionKeyUrl = (Get-AzureKeyVaultKey -VaultName $KeyVaultName -Name $keyEncryptionKeyName).Key.kid;
<# Add the key from Key Vault to the server #>
Add-AzureRmSqlServerKeyVaultKey -ResourceGroupName $dbRG -ServerName $dbServer -KeyId $keyEncryptionKeyUrl

<# Set the key as the TDE protector for all resources under the server #>
Set-AzureRmSqlServerTransparentDataEncryptionProtector -ResourceGroupName $dbRG -ServerName $dbServer -Type AzureKeyVault -KeyId $keyEncryptionKeyUrl
<# To confirm that the TDE protector was configured as intended: #>
Get-AzureRmSqlServerTransparentDataEncryptionProtector -ResourceGroupName $dbRG -ServerName $dbServer

$dbName = 'MojaBazaDanych'
Set-AzureRMSqlDatabaseTransparentDataEncryption -ResourceGroupName $dbRG -ServerName $dbServer -DatabaseName $dbName -State "Enabled"
