﻿using System;
using System.Net.Mail;
using System.Threading;

namespace Synchronization
{
    static class EventObjects
    {
        static void LogFailure(string message, string mailServer)
        {
            var email = new SmtpClient(mailServer);

            using (var emailSent = new ManualResetEvent(false))
            {
                object sync = new object();
                bool tooLate = false; // Uniemożliwiamy wywoływanie metody Set po upłynięciu limitu czasu
                email.SendCompleted += (s, e) =>
                { lock (sync) { if (!tooLate) { emailSent.Set(); } } };
                email.SendAsync("logger@example.com", "sysadmin@example.com",
                    "Zgłoszenie awarii", "Wystąpił błąd: " + message, null);

                LogPersistently(message);

                if (!emailSent.WaitOne(TimeSpan.FromMinutes(1)))
                {
                    LogPersistently("Upłynął limit czasu wysyłania wiadomości: " + message);
                }

                lock (sync)
                {
                    tooLate = true;
                }
            }
        }

        private static void LogPersistently(string message)
        {
            // To tylko demonstracja.
        }
    }
}
