# Rozdział 16. - Przykłady

Przykłady do rozdziału 16. pt. *Wielowątkowość* książki *C# 8.0 Programowanie*.

## Wątki

* [Listing 1. Obiekt dostępny wyłącznie wewnątrz metody, w której został zadeklarowany](Wielowatkowosc/Threading/Program.cs#L14-L25)
* [Listing 2. Niebezpieczne pod względem pracy wielowątkowej użycie bezpiecznej kolekcji](Wielowatkowosc/Threading/Program.cs#L27-L31)
* [Listing 3. Zastosowanie klasy ThreadLocal&lt;T&gt;>](Wielowatkowosc/Threading/Notifier.cs#L6-L36)
* [Listing 4. Tworzenie wątków](Wielowatkowosc/CreatingThreads/Program.cs#L7-L31)
* [Listing 5. Uruchamianie kodu w puli wątków przy wykorzystaniu klasy Task](Wielowatkowosc/Threading/TaskThreadPool.cs#L11)
* [Listing 6. Stosowanie puli wątków oraz klasy SynchronizationContext](Wielowatkowosc/ThreadAffinity/MainWindow.xaml.cs#L20-L42)
* [Listing 7. Korzystanie z klasy ExecutionContext](Wielowatkowosc/ThreadAffinity/Defer.cs#L6-L21)

## Synchronizacja

* [Listing 8. Zabezpieczanie stanu przy użyciu słowa kluczowego lock](Wielowatkowosc/Synchronization/SaleLog.cs#L5-L42)
* [Listing 9. Sposób przetwarzania bloku instrukcji lock](Wielowatkowosc/Synchronization/EquivalentOfLock.cs#L49-L65)
* [Listing 10. Zastosowanie metod Wait oraz Pulse](Wielowatkowosc/Synchronization/MessageQueue.cs#L6-L36)
* [Listing 11. Zabezpieczanie dostępu do danej typu decimal przy użyciu klasy SpinLock](Wielowatkowosc/Synchronization/DecimalTotal.cs#L5-L47)
* [Listing 12. Oczekiwanie na wykonanie operacji przy użyciu klasy ManualResetEvent](Wielowatkowosc/Synchronization/EventObjects.cs#L9-L34)
* [Listing 13. Zastosowanie metody CompareExchange](Wielowatkowosc/Synchronization/UsingCompareExchange.cs#L7-L18)
* [Listing 14. Zastosowanie klasy LazyInitializer](Wielowatkowosc/Synchronization/Cache.cs#L6-L12)

## Zadania

* [Listing 15. Pobieranie kodu strony WWW przy wykorzystaniu zadań](Wielowatkowosc/Tpl/Program.cs#L12-L14)
* [Listing 16. Pobieranie wyniku zadania przy użyciu słowa kluczowego await](Wielowatkowosc/Tpl/Program.cs#L16)
* [Listing 17. Kontynuacja](Wielowatkowosc/Tpl/Program.cs#L19-L23)
* [Listing 18. Anulowanie i sekwencja kontynuacji](Wielowatkowosc/Tpl/Program.cs#L27-L43)
* [Listing 19. Planowanie wykonania kontynuacji w wątku obsługi interfejsu użytkownika](Wielowatkowosc/TplSchedulers/MainWindow.xaml.cs#L10-L34)
* [Listing 20. Zastosowanie klasy TaskCompletionSource&lt;T&gt;](Wielowatkowosc/Tpl/SmtpAsyncExtensions.cs#L7-L36)
* [Listing 21. Para metod APM oraz odpowiadająca im metoda synchroniczna](Wielowatkowosc/Tpl/Program.cs#L48-L52)
* [Listing 22. Równoległe obliczanie splotu](Wielowatkowosc/Tpl/ParallelFor.cs#L8-L22)
