﻿using System;
using System.Collections.Generic;
using System.Reflection;
using System.Runtime.Loader;

namespace HostApp
{
    public class PlugInLoadContext : AssemblyLoadContext
    {
        private readonly AssemblyDependencyResolver _resolver;
        private readonly ICollection<string> _plugInApiAssemblyNames;

        public PlugInLoadContext(
            string pluginPath,
            ICollection<string> plugInApiAssemblies)
        {
            _resolver = new AssemblyDependencyResolver(pluginPath);
            _plugInApiAssemblyNames = plugInApiAssemblies;
        }

        protected override Assembly Load(AssemblyName assemblyName)
        {
            if (!_plugInApiAssemblyNames.Contains(assemblyName.Name))
            {
                string assemblyPath = _resolver.ResolveAssemblyToPath(assemblyName);
                if (assemblyPath != null)
                {
                    return LoadFromAssemblyPath(assemblyPath);
                }
            }

            return AssemblyLoadContext.Default.LoadFromAssemblyName(
                assemblyName);
        }
    }
}