# Rozdział 9. - Przykłady

Przykłady do rozdziału 9. pt. *Delegaty, wyrażenia lambda i zdarzenia* książki *C# 8.0 Programowanie*.

* [Listing 1. Przeszukiwanie tablicy przy wykorzystaniu delegata](DelegatyLambdyZdarzenia/Delegates/Program.cs#L12-L15)

## Typy delegatów

* [Listing 2. Metoda z parametrem typu delegatu](DelegatyLambdyZdarzenia/Delegates/Program.cs#L20-L23)
* [Listing 3. Typ delegatu Predicate&lt;T&gt;](DelegatyLambdyZdarzenia/Delegates/Program.cs#L25)
* [Listing 4. Tworzenie delegatu](DelegatyLambdyZdarzenia/Delegates/Program.cs#L48)
* [Listing 5. Niejawne tworzenie delegatu](DelegatyLambdyZdarzenia/Delegates/Program.cs#L55)
* [Listing 6. Delegaty do metod zdefiniowanych w innej klasie](DelegatyLambdyZdarzenia/DelegatesOtherClass/Program.cs#L5-L19)
* [Listing 7. Niejawne delegacje instancji](DelegatyLambdyZdarzenia/Delegates/ThresholdComparer.cs#L5-L12)
* [Listing 8. Jawne delegaty instancji](DelegatyLambdyZdarzenia/Delegates/Program.cs#L62-L68)
* [Listing 9. Zastosowanie metody CreateDelegate](DelegatyLambdyZdarzenia/Delegates/Program.cs#L84-L88)
* [Listing 10. Łączenie delegatów](DelegatyLambdyZdarzenia/Delegates/Program.cs#L74-L79)
* [Listing 11. Wywoływanie delegatów](DelegatyLambdyZdarzenia/Delegates/Program.cs#L93-L97)
* [Listing 12. Wywoływanie każdego z delegatów z osobna](DelegatyLambdyZdarzenia/Delegates/Program.cs#L99-L127)
* [Listing 13. Pierwsze cztery delegaty Action](DelegatyLambdyZdarzenia/Delegates/Program.cs#L27-L30)
* [Listing 14. Kilka pierwszych delegatów Func](DelegatyLambdyZdarzenia/Delegates/Program.cs#L32-L36)
* [Listing 15. Kowariancja delegatów](DelegatyLambdyZdarzenia/DelegateConversion/Program.cs#L7-L17)
* [Listing 16. Niedozwolona konwersja delegatów](DelegatyLambdyZdarzenia/DelegateConversion/Program.cs#L24-L25)
* [Listing 17. Delegat odwołujący się do delegatu](DelegatyLambdyZdarzenia/DelegateConversion/Program.cs#L31-L34)
* [Listing 18. Delegat, który jawnie odwołuje się do innego delegatu](DelegatyLambdyZdarzenia/DelegateConversion/Program.cs#L41-L42)
* [Listing 19. Nowy delegat dla tej samej metody docelowej](DelegatyLambdyZdarzenia/DelegateConversion/Program.cs#L50-L52)
* [Listing 20. Konwersja delegatów zbiorowych](DelegatyLambdyZdarzenia/DelegateConversion/Program.cs#L58-L70)
* [Listing 21. Składowe typu delegatu](DelegatyLambdyZdarzenia/Delegates/Program.cs#L38-L43)
* [Listing 22. Jawne stosowanie metody Invoke](DelegatyLambdyZdarzenia/Delegates/ExplicitInvoke.cs#L7-L11)
* [Listing 23. Zastosowanie metody Invoke wraz z operatorem warunkowych wartości pustych](DelegatyLambdyZdarzenia/Delegates/ConditionalInvoke.cs#L7-L10)

## Funkcje anonimowe

* [Listing 24. Składnia metody anonimowej](DelegatyLambdyZdarzenia/AnonymousFunctions/AnonymousMethodSyntax.cs#L8-L14)
* [Listing 25. Składnia wyrażeń lambda](DelegatyLambdyZdarzenia/AnonymousFunctions/LambdaSyntax.cs#L7-L13)
* [Listing 26. Różne sposoby zapisu wyrażeń lambda](DelegatyLambdyZdarzenia/AnonymousFunctions/LambdaSyntax.cs#L17-L22)
* [Listing 27. Bezargumentowe wyrażenie lambda](DelegatyLambdyZdarzenia/AnonymousFunctions/LambdaSyntax.cs#L34)
* [Listing 28. Ignorowanie argumentów w metodzie anonimowej](DelegatyLambdyZdarzenia/AnonymousFunctions/AnonymousMethodSyntax.cs#L18)
* [Listing 29. Korzystanie ze zmiennych dostępnych w metodzie zawierającej wyrażenie lambda](DelegatyLambdyZdarzenia/AnonymousFunctions/VariableFromContainingMethod.cs#L10-L13)
* [Listing 30. Użycie zmiennej z metody zawierającej wyrażenie lambda](DelegatyLambdyZdarzenia/AnonymousFunctions/VariableFromContainingMethodExpressionBodied.cs#L7-L8)
* [Listing 31. Skąd pochodzi wartość](DelegatyLambdyZdarzenia/AnonymousFunctions/VariableFromContainingMethodExpressionBodied.cs#L12-L13)
* [Listing 32. Wygenerowany kod funkcji anonimowej](DelegatyLambdyZdarzenia/AnonymousFunctions/VariableFromContainingMethod.cs#L18-L27)
* [Listing 33. Modyfikacja przechwyconej zmiennej](DelegatyLambdyZdarzenia/AnonymousFunctions/VariableFromContainingMethod.cs#L29-L48)
* [Listing 34. Przedwczesne zwolnienie zasobów](DelegatyLambdyZdarzenia/AnonymousFunctions/VariableFromContainingMethod.cs#L53-L61)
* [Listing 35. Problematyczne przechwytywanie zmiennych w pętli for](DelegatyLambdyZdarzenia/AnonymousFunctions/VariableFromContainingMethod.cs#L65-L75)
* [Listing 36. Modyfikacja pętli w celu przechwytywania aktualnej wartości licznika](DelegatyLambdyZdarzenia/AnonymousFunctions/VariableFromContainingMethod.cs#L80-L84)
* [Listing 37. Przechwytywanie zmiennych o różnym zakresie](DelegatyLambdyZdarzenia/AnonymousFunctions/VariableFromContainingMethod.cs#L94-L99)
* [Listing 38. Wyrażenie lambda](DelegatyLambdyZdarzenia/AnonymousFunctions/ExpressionTrees.cs#L10)
* [Listing 39. Co kompilator robi z wyrażeniem lambda](DelegatyLambdyZdarzenia/AnonymousFunctions/ExpressionTrees.cs#L15-L19)
* [Listing 40. Wyrażenia i zapytania do baz danych](DelegatyLambdyZdarzenia/AnonymousFunctions/DataAccess.cs#L12)
* [Listing 41. Użycie wyrażeń lambda w bibliotece Moq](DelegatyLambdyZdarzenia/AnonymousFunctions/MoqLambdas.cs#L11-L14)

## Zdarzenia

* [Listing 42. Klasa ze zdarzeniem](DelegatyLambdyZdarzenia/Events/Eventful.cs#L5-L13)
* [Listing 43. Obsługa zdarzeń](DelegatyLambdyZdarzenia/Events/Program.cs#L9-L10)
* [Listing 44. W jaki sposób nie należy zgłaszać zdarzeń](DelegatyLambdyZdarzenia/Events/Program.cs#L18-L19)
* [Listing 45. Przybliżony efekt deklaracji zdarzenia](DelegatyLambdyZdarzenia/Events/RouglyHowEventsWork.cs#L9-L22)
* [Listing 46. Typ delegatu EventHandler](DelegatyLambdyZdarzenia/Events/Program.cs#L27)
* [Listing 47. Niestandardowe metody dodające i usuwające sporadycznie obsługiwane zdarzenia](DelegatyLambdyZdarzenia/Events/ScarceEventSource.cs#L6-L83)
