﻿namespace Constraints
{
    using System;
    using System.Collections.Generic;

    public class GenericComparer<T> : IComparer<T>
        where T : IComparable<T>
    {
        public int Compare(T x, T y)
        {
            return x.CompareTo(y);
        }
    }

    // Kolejne dwa przykłady przedstawiają wersje klasy, których nie uda się skompilować,
    // gdyż w książce pokazano je jako przykłady rzeczy które nie będą działać.
    // To właśnie dlatego zostały one umieszczone w bloku #if false.
#if false
    public class GenericComparer<T> : IComparer<T>
    {
        public int Compare(IComparable<T> x, T y)
        {
            return x.CompareTo(y);
        }
    }

    public class GenericComparer<T> : IComparer<T>
    {
        public int Compare(T x, T y)
        {
            return x.CompareTo(y);
        }
    }
#endif
}