﻿using System;
using System.Collections.Generic;

namespace DelegateBasedPubSub
{
    public class KeyWatcher : IObservable<char>
    {
        private readonly List<Subscription> _subscriptions = new List<Subscription>();

        public IDisposable Subscribe(IObserver<char> observer)
        {
            var sub = new Subscription(this, observer);
            _subscriptions.Add(sub);
            return sub;
        }

        public void Run()
        {
            while (true)
            {
                // Przekazanie wartości true sprawia, że znaki nie będą wyświetlane na konsoli
                char c = Console.ReadKey(true).KeyChar;
                // Przeglądamy kopię, by obsłużyć sytuację kiedy obserwator anuluje subskrypcję
                // wewnątrz metody OnNext
                foreach (Subscription sub in _subscriptions.ToArray())
                {
                    sub.Observer.OnNext(c);
                }
            }
        }

        private void RemoveSubscription(Subscription sub)
        {
            _subscriptions.Remove(sub);
        }

        private class Subscription : IDisposable
        {
            private KeyWatcher _parent;
            public Subscription(KeyWatcher parent, IObserver<char> observer)
            {
                _parent = parent;
                Observer = observer;
            }

            public IObserver<char> Observer { get; }

            public void Dispose()
            {
                if (_parent != null)
                {
                    _parent.RemoveSubscription(this);
                    _parent = null;
                }
            }
        }
    }
}