﻿using System;

namespace BasicCoding
{
    internal static class Patterns
    {
        internal static void TuplePatterns((int x, int y) p)
        {
            switch (p)
            {
                case (0, 0):
                    Console.WriteLine("Jak oryginalnie...");
                    break;

                case (0, 1):
                case (1, 0):
                    Console.WriteLine("Cóż za symetria...");
                    break;

                case (1, 1):
                    Console.WriteLine("Po równo...");
                    break;
            }
        }

        internal static void TypePatterns(object o)
        {
            switch (o)
            {
                case string s:
                    Console.WriteLine($"Łańcuch ma długość {s.Length} znaków.");
                    break;

                case int i:
                    Console.WriteLine($"To jest liczba! {i}");
                    break;
            }
        }

        internal static void PositionalPatterns(object o)
        {
            switch (o)
            {
                case (0, int y):
                    Console.WriteLine($"To na osi X, na wysokości {y}");
                    break;

                case (int x, int y):
                    Console.WriteLine($"Znam to miejsce: {x}, {y}");
                    break;

                case (int x, _):
                    Console.WriteLine($"X to: {x}. A jakie jest Y? Kto to wie...");
                    break;

                case (var x, var y):
                    Console.WriteLine($"Znam to miejsce: {x}, {y}");
                    break;
            }
        }

        internal static void PropertyPatterns(object o)
        {
            switch (o)
            {
                case string { Length: 0 }:
                    Console.WriteLine("Jaką długość ma łańcuch? Niewielką!");
                    break;
            }

            switch (o)
            {
                case string { Length: 0 } s:
                    Console.WriteLine($"Jaką długość ma łańcuch? Ten liczy {s.Length} znaków.");
                    break;
            }

            switch (o)
            {
                case string { Length: int length }:
                    Console.WriteLine($"Jaką długość ma łańcuch? Ten liczy {length} znaków.");
                    break;
            }
        }

        internal static void PatternsWithWhen(object o)
        {
            switch (o)
            {
                case (int w, int h) when w > h:
                    Console.WriteLine("Tryb poziomy");
                    break;
            }
        }

        internal static string NonExpressionPatterns(object shape)
        {
            switch (shape)
            {
                case (int w, int h) when w < h: return "Pionowy";
                case (int w, int h) when w > h: return "Poziomy";
                case (int _, int _): return "Kwadrat";
                default: return "Nieznany";
            }
        }

        internal static string ExpressionPatterns(object shape)
        {
            return shape switch
            {
                (int w, int h) when w < h => "Pionowy",
                (int w, int h) when w > h => "Poziomy",
                (int _, int _) => "Kwadrat",
                _ => "Nieznany"
            };
        }

        [System.Diagnostics.CodeAnalysis.SuppressMessage("Style", "IDE0059:Unnecessary assignment of a value", Justification = "W tym przykładzie zmienne nie są używane")]
        internal static void IsExpression(object value)
        {
            bool isPoint = value is (int x, int y);
        }

        internal static void MoreIsExpressions(object value)
        {
            if (value is (int x, int y))
            {
                Console.WriteLine($"X: {x}, Y: {y}");
            }

            if (value is (int w, int h) && w < h)
            {
                Console.WriteLine($"(Tryb poziomy) szerokość: {w}, wysokość: {h}");
            }
        }
    }
}
