﻿using System;
using System.Runtime.CompilerServices;

namespace WeakRefs
{
    class Program
    {
        static WeakCache<string, byte[]> cache = new WeakCache<string, byte[]>();
        static byte[] data = new byte[100];

        static void Main(string[] args)
        {
            AddData();
            CheckStillAvailable();

            GC.Collect();
            CheckStillAvailable();

            SetOnlyRootToNull();
            GC.Collect();
            CheckNoLongerAvailable();
        }

        [MethodImpl(MethodImplOptions.NoInlining)]
        private static void AddData()
        {
            cache.Add("d", data);
        }

        [MethodImpl(MethodImplOptions.NoInlining)]
        private static void CheckStillAvailable()
        {
            Console.WriteLine("Pobranie: " +
                cache.TryGetValue("d", out byte[] fromCache));
            Console.WriteLine("Ta sama referencja? " +
                object.ReferenceEquals(data, fromCache));
        }

        [MethodImpl(MethodImplOptions.NoInlining)]
        private static void SetOnlyRootToNull()
        {
            data = null;
        }

        [MethodImpl(MethodImplOptions.NoInlining)]
        private static void CheckNoLongerAvailable()
        {
            byte[] fromCache;
            Console.WriteLine("Pobranie: " + cache.TryGetValue("d", out fromCache));
            Console.WriteLine("Czy null? " + (fromCache == null));
        }
    }
}
