﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Dictionaries
{
    public class UserCache
    {
        private readonly Dictionary<string, UserInfo> _cachedUserInfo =
            new Dictionary<string, UserInfo>();

        public UserInfo GetInfo(string userHandle)
        {
            RemoveStaleCacheEntries();
            if (!_cachedUserInfo.TryGetValue(userHandle, out UserInfo info))
            {
                info = FetchUserInfo(userHandle);
                _cachedUserInfo.Add(userHandle, info);
            }
            return info;
        }

        private UserInfo FetchUserInfo(string userHandle)
        {
            // ... pobranie danych użytkownika ...
            return new UserInfo();
        }

        private void RemoveStaleCacheEntries()
        {
            // ... używana w tej aplikacji logika usuwania niepotrzebnych danych ...
        }
    }

    public class UserInfo
    {
        // ... informacje o użytkowniku ...
    }
}
