﻿using System;
using System.IO;
using System.Text;
using System.Xml;

namespace Text
{
    class Program
    {
        static void Main(string[] args)
        {
            using (var fw = new StreamWriter(@"c:\temp\out.txt"))
            {
                fw.WriteLine($"Zapis do pliku o godzinie {DateTime.Now}");
            }

            string xmlContent =
                "<message><text>Witaj</text><recipient>świat</recipient></message>";
            var xmlReader = XmlReader.Create(new StringReader(xmlContent));
            while (xmlReader.Read())
            {
                if (xmlReader.NodeType == XmlNodeType.Text)
                {
                    Console.WriteLine(xmlReader.Value);
                }
            }

            using (var sw = new StreamWriter("Test.txt", false,
                                 Encoding.GetEncoding(1252)))
            {
                sw.Write("£100");
            }
        }
    }

    // Składowe klasy FileStream, przedsatwione wyłącznie w celach demonstracyjnych.
    // Typ ten jest zdefiniowany w bibliotece .NET więc nie musimy go definiować samodzielnie

#if false
    public virtual int Read(char[] buffer, int index, int count) { ... }
    public virtual int ReadBlock(char[] buffer, int index, int count) { ... }
#endif
}