﻿namespace AddisonWesley.Michaelis.EssentialCSharp.AppendixC.ListingC_09
{
    using System;
    using System.ComponentModel;
    using System.Text;
    using System.Threading;

    public class PiCalculator
    {
        public static BackgroundWorker calculationWorker =
            new BackgroundWorker();
        public static AutoResetEvent resetEvent =
            new AutoResetEvent(false);

        public static void Main()
        {
            int digitCount;

            Console.Write(
                "Podaj liczbę wyznaczanych cyfr:");
            if(int.TryParse(Console.ReadLine(), out digitCount))
            {
                Console.WriteLine("Wciśnij ENTER, aby anulować.");
                // Składnia rejestrowania delegatów z wersji C# 2.0.
                calculationWorker.DoWork += CalculatePi;
                // Rejestrowanie wywołania zwrotnego wiązanego ze zdarzeniem ProgressChanged.
                calculationWorker.ProgressChanged +=
                    UpdateDisplayWithMoreDigits;
                calculationWorker.WorkerReportsProgress = true;
                // Rejestrowanie wywołania zwrotnego uruchamianego po zakończeniu obliczeń.
                calculationWorker.RunWorkerCompleted +=
                    new RunWorkerCompletedEventHandler(Complete);
                calculationWorker.WorkerSupportsCancellation = true;

                // Rozpoczynanie wyznaczania digitCount cyfr liczby pi.
                calculationWorker.RunWorkerAsync(digitCount);

                Console.ReadLine();
                // Jeśli żądanie anulowania zostanie zgłoszone po
                // zakończeniu obliczeń, jest ignorowane.
                calculationWorker.CancelAsync();
                // Oczekiwanie na uruchomienie metody Complete(). 
                resetEvent.WaitOne();
            }
            else
            {
                Console.WriteLine(
                    "Wprowadzona wartość to nieprawidłowa liczba całkowita.");
            }
        }

        private static void CalculatePi(
            object sender, DoWorkEventArgs eventArgs)
        {
            int digits = (int)eventArgs.Argument;

            StringBuilder pi = new StringBuilder("3.", digits + 2);
            calculationWorker.ReportProgress(0, pi.ToString());

            // Obliczanie dalszych cyfr liczby pi, jeśli są potrzebne.
            if (digits > 0)
            {
                for(int i = 0; i < digits; i += 9)
                {

                    // Obliczanie następnych i miejsc po przecinku.
                    int nextDigit = Shared.PiCalculator.InternalPiDigitCalculator.ComputeSection(
                        i + 1);
                    int digitCount = Math.Min(digits - i, 9);
                    string ds = string.Format("{0:D9}", nextDigit);
                    pi.Append(ds.Substring(0, digitCount));

                    // Wyświetlanie aktualnych informacji o postępie.
                    calculationWorker.ReportProgress(
                        0, ds.Substring(0, digitCount));

                    // Wykrywanie anulowania.
                    if (calculationWorker.CancellationPending)
                    {
                        // Trzeba ustawić właściwość Cancel, jeśli możliwe
                        // ma być ustalenie (na przykład w wyniku sprawdzenia
                        // wartości właściwości RunWorkerCompletedEventArgs.Cancelled), 
                        // jak wątek roboczy zakończył pracę.
                        eventArgs.Cancel = true;
                        break;
                    }
                }
            }

            eventArgs.Result = pi.ToString();
        }

        private static void UpdateDisplayWithMoreDigits(
            object sender, ProgressChangedEventArgs eventArgs)
        {
            string digits = (string)eventArgs.UserState;

            Console.Write(digits);
        }

        static void Complete(
            object sender, RunWorkerCompletedEventArgs eventArgs)
        {
            Console.WriteLine();
            if(eventArgs.Cancelled)
            {
                Console.WriteLine("Anulowano");
            }
            else if(eventArgs.Error != null)
            {
                // WAŻNE: sprawdzanie błędu, by pobrać wyjątki.
                Console.WriteLine("BŁĄD: {0}", eventArgs.Error.Message);
            }
            else
            {
                Console.WriteLine("Zakończono (wciśnij ENTER, by kontynuować)");
            }
            resetEvent.Set();
        }
    }
}