namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter05.Listing05_13
{
    // Dodanie przestrzeni nazw IO.
    using System.IO;
    using Listing05_12;

    class DataStorage
    {
        // Zapisywanie obiektu employee w pliku 
        // o nazwie odpowiadajcej imieniu i nazwisku pracownika.
        // Obsug bdw pominito.
        public static void Store(Employee employee)
        {
            // Tworzenie obiektu typu FileStream z nazw pliku 
            // FirstNameLastName.dat. Parametr FileMode.Create powoduje 
            // utworzenie nowego pliku lub zastpienie zawartoci istniejcego.
            FileStream stream = new FileStream(
                employee.FirstName + employee.LastName + ".dat",
                FileMode.Create);

            // Tworzenie obiektu typu StreamWriter na potrzeby zapisu
            // tekstu w obiekcie typu FileStream.
            StreamWriter writer = new StreamWriter(stream);

            // Zapis wszystkich danych dotyczcych pracownika.
            writer.WriteLine(employee.FirstName);
            writer.WriteLine(employee.LastName);
            writer.WriteLine(employee.Salary);

            // Zamyka obiekt typu StreamWriter i powizany z nim strumie.
            writer.Close();  // Automatycznie zamyka strumie.
        }
        // ...
    }
}
