﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter13.Listing13_06
{
    using System;

    public class Thermostat
    {
        // Definicja nadawcy zdarzeń
        public Action<float> OnTemperatureChange { get; set; }

        public float CurrentTemperature
        {
            get { return _CurrentTemperature; }
            set
            {
                if(value != CurrentTemperature)
                {
                    _CurrentTemperature = value;
                    // Jeśli istnieją subskrybenci, 
                    // należy ich powiadomić o zmianie temperatury.
                    Action<float> localOnChange =
                        OnTemperatureChange;
                    if(localOnChange != null)
                    {
                        // Wywołanie subskrybentów
                        localOnChange(value);
                    }
                }
            }
        }

        private float _CurrentTemperature;
    }
}