﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter09.Listing09_19
{
    using System;
    using System.IO;

    public class Program
    {
        private WeakReference Data;

        public FileStream GetData()
        {
            FileStream data = (FileStream)Data.Target;

            if(data != null)
            {
                return data;
            }
            else
            {
                // Wczytywanie danych
                // ...

                // Tworzenie słabej referencji do
                // zmiennej dane w celu jej późniejszego użycia.
                Data.Target = data;
            }
            return data;
        }

        public static void Main()
        {
            Console.WriteLine("Bez danych wyjściowych.");
        }
    }
}