﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter05.Listing05_14
{
    using System;
    using System.IO;

    public class Program
    {
        public static void Main()
        {
            Employee employee1;

            Employee employee2 = new Employee();
            employee2.SetName("Inigo", "Montoya");
            employee2.Save();

            // Modyfikowanie obiektu employee2 po zapisaniu.
            IncreaseSalary(employee2);

            // Wczytywanie danych do obiektu employee1 z zapisanego obiektu employee2
            employee1 = DataStorage.Load("Inigo", "Montoya");

            Console.WriteLine(
                $"{ employee1.GetName() }: { employee1.Salary }");
        }

        static void IncreaseSalary(Employee employee)
        {
            employee.Salary = "Wystarczająco, by przeżyć";
        }
    }

    class Employee
    {
        public string FirstName;
        public string LastName;
        public string Salary;

        public string GetName()
        {
            return $"{ FirstName }  { LastName }";
        }

        public void SetName(string newFirstName, string newLastName)
        {
            this.FirstName = newFirstName;
            this.LastName = newLastName;
            Console.WriteLine(
                $"Imię i nazwisko zmieniono na '{ this.GetName() }'");
        }

        public void Save()
        {
            DataStorage.Store(this);
        }
    }

    class DataStorage
    {
        // Zapisywanie obiektu employee w pliku 
        // o nazwie odpowiadającej imieniu i nazwisku pracownika.
        // Obsługę błędów pominięto.
        public static void Store(Employee employee)
        {
            // Tworzenie obiektu typu FileStream z nazwą pliku 
            // FirstNameLastName.dat. Parametr FileMode.Create powoduje 
            // utworzenie nowego pliku lub zastąpienie zawartości istniejącego.
            FileStream stream = new FileStream(
                employee.FirstName + employee.LastName + ".dat",
                FileMode.Create);

            // Tworzenie obiektu typu StreamWriter na potrzeby zapisu
            // tekstu w obiekcie typu FileStream.
            StreamWriter writer = new StreamWriter(stream);

            // Zapis wszystkich danych dotyczących pracownika.
            writer.WriteLine(employee.FirstName);
            writer.WriteLine(employee.LastName);
            writer.WriteLine(employee.Salary);

            // Zamyka obiekt typu StreamWriter i powiązany z nim strumień.
            writer.Close();  // Automatycznie zamyka strumień.
        }

        public static Employee Load(string firstName, string lastName)
        {
            Employee employee = new Employee();

            // Tworzenie obiektu typu FileStream dla pliku o nazwie 
            // FirstNameLastName.dat. Parametr FileMode.Open powoduje 
            // otwarcie istniejącego pliku lub zgłoszenie błędu.
            FileStream stream = new FileStream(
                firstName + lastName + ".dat", FileMode.Open);

            // Tworzenie obiektu typu SteamReader przeznaczonego do odczytu tekstu z pliku.
            StreamReader reader = new StreamReader(stream);

            // Wczytywanie każdego wiersza z pliku i zapisywanie 
            // danych w odpowiedniej właściwości.
            employee.FirstName = reader.ReadLine();
            employee.LastName = reader.ReadLine();
            employee.Salary = reader.ReadLine();

            // Zamykanie obiektu typu StreamReader i powiązanego z nim strumienia.
            reader.Close();  // Automatycznie zamyka strumień.

            return employee;
        }
    }

}
