﻿namespace AddisonWesley.Michaelis.EssentialCSharp.AppendixD.ListingD_01
{
    using System;
    using System.Threading;
    using System.Timers;
    // Ponieważ klasa Timer występuje w przestrzeniach nazw System.Timers i
    // System.Threading, nazwa Timer jest dookreślana za pomocą dyrektywy z aliasem.
    using Timer = System.Timers.Timer;

    class UsingSystemTimersTimer
    {
        private static int _Count = 0;
        private static readonly ManualResetEvent _ResetEvent =
           new ManualResetEvent(false);
        private static int _AlarmThreadId;

        public static void Main()
        {
            using(Timer timer = new Timer())
            {
                // Inicjowanie zegara.
                timer.AutoReset = true;
                timer.Interval = 1000;
                timer.Elapsed += new ElapsedEventHandler(Alarm);

                timer.Start();

                // Oczekiwanie na zgłoszenie alarmu po raz 10.
                _ResetEvent.WaitOne();
            }

            // Sprawdzanie, czy wątek zgłaszający alarm
            // różni się od wątku wykonującego metodę Main.
            if (_AlarmThreadId ==
                Thread.CurrentThread.ManagedThreadId)
            {
                throw new ApplicationException(
                    "Identyfikatory wątków są takie same.");
            }
            if(_Count < 9)
            {
                throw new ApplicationException(" _Count < 9");
            };

            Console.WriteLine(
                "(ID wątku z alarmem) {0} != {1} (ID wątku z metodą Main)",
                _AlarmThreadId,
                Thread.CurrentThread.ManagedThreadId);
            Console.WriteLine("Ostateczna wartość licznika = {0}", _Count);
        }

        static void Alarm(object sender, ElapsedEventArgs eventArgs)
        {
            _Count++;

            Console.WriteLine("{0}:- {1}",
                eventArgs.SignalTime.ToString("T"),
                _Count);

            if(_Count >= 9)
            {
                _AlarmThreadId =
                    Thread.CurrentThread.ManagedThreadId;
                _ResetEvent.Set();
            }
        }
    }
}
