﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter13.Listing13_04
{
    using System;

    public class Thermostat
    {
        // Definicja nadawcy zdarzeń
        public Action<float> OnTemperatureChange { get; set; }

        public float CurrentTemperature
        {
            get { return _CurrentTemperature; }
            set
            {
                if(value != CurrentTemperature)
                {
                    _CurrentTemperature = value;

                    // NIEKOMPLETNE: trzeba sprawdzać, czy wartość jest różna od null.
                    // Wywołanie kierowane do subskrybentów.
                    OnTemperatureChange(value);
                }
            }
        }
        private float _CurrentTemperature;
    }
}