﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter08.Listing08_03
{
    // Słowo kluczowe struct służy do deklarowania typów bezpośrednich.
    struct Angle
    {
        // BŁĄD: obiektu 'this' nie można użyć przed
        //      przypisaniem wartości do wszystkich jego pól.
        // public Angle(int degrees, int minutes, int seconds)
        // {
        //     Degrees = degrees;    // Skrócony zapis instrukcji this.Hours = hours;
        //     Minutes = minutes; // Skrócony zapis instrukcji this.Minutes = ...;
        //     Seconds = seconds; // Skrócony zapis instrukcji this.Seconds = ...;
        // }

        public Angle(int degrees, int minutes, int seconds)
        {
            _Degrees = degrees; // Skrócony zapis instrukcji this.Degrees = ...;
            _Minutes = minutes; // Skrócony zapis instrukcji this.Minutes = ...;
            _Seconds = seconds; // Skrócony zapis instrukcji this.Seconds = ...;
        }

        public int Degrees { get { return _Degrees; } }
        readonly private int _Degrees;

        public int Minutes { get { return _Minutes; } }
        readonly private int _Minutes;

        public int Seconds { get { return _Seconds; } }
        readonly private int _Seconds;

        public Angle Move(int degrees, int minutes, int seconds)
        {
            return new Angle(
                Degrees + degrees,
                Minutes + minutes,
                Seconds + seconds);
        }
    }

    // Deklarowanie klasy (typu referencyjnego).
    // Zadeklarowanie tego typu jako struktury spowoduje utworzenie typu
    // bezpośredniego o wielkości większej niż 16 bajtów.
    class Coordinate
    {
        public Angle Longitude
        {
            get { return _Longitude; }
            set { _Longitude = value; }
        }
        private Angle _Longitude;

        public Angle Latitude
        {
            get { return _Latitude; }
            set { _Latitude = value; }
        }
        private Angle _Latitude;
    }
}