﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter05.Listing05_45
{
    using System;

    class Program
    {
        // Definiowanie klasy zagnieżdżonej służącej do przetwarzania wiersza poleceń.
        private class CommandLine
        {
            public CommandLine(string[] arguments)
            {
                for(int argumentCounter = 0;
                    argumentCounter < arguments.Length;
                    argumentCounter++)
                {
                    switch(argumentCounter)
                    {
                        case 0:
                            Action = arguments[0].ToLower();
                            break;
                        case 1:
                            Id = arguments[1];
                            break;
                        case 2:
                            FirstName = arguments[2];
                            break;
                        case 3:
                            LastName = arguments[3];
                            break;
                    }
                }
            }
            public string Action;
            public string Id;
            public string FirstName;
            public string LastName;
        }

        public static void Main(string[] args)
        {
            CommandLine commandLine = new CommandLine(args);

            switch(commandLine.Action)
            {
                case "new":
                    // Tworzenie nowego obiektu reprezentującego pracownika.
                    Console.WriteLine("Tworzenie nowego obiektu typu Employee.");
                    break;
                case "update":
                    // Aktualizowanie danych w istniejącym obiekcie reprezentującym pracownika.
                    Console.WriteLine("Aktualizowanie obiektu typu Employee.");
                    break;
                case "delete":
                    // Usuwanie pliku z danymi pracownika.
                    Console.WriteLine("Usuwanie obiektu typu Employee.");
                    break;
                default:
                    Console.WriteLine(
                        "Employee.exe new|update|delete " +
                        "<id> [imię] [nazwisko]");
                    break;
            }
        }
    }
}
