using System;

namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter05.Listing05_19
{
    class Employee
    {
        // ...
        public void Initialize(
            string newFirstName, string newLastName)
        {
            // Uywanie waciwoci take wewntrz 
            // klasy Employee.
            FirstName = newFirstName;
            LastName = newLastName;
        }

        // Waciwo LastName
        public string LastName
        {
            get
            {
                return _LastName;
            }
            set
            {
                // Sprawdzanie poprawnoci w trakcie przypisywania wartoci waciwoci LastName.
                if (value == null)
                {
                    // Zgaszanie bdu
                    throw new ArgumentNullException(nameof(value));
                }
                else
                {
                    // Usuwanie odstpw wok nazwiska.
                    value = value.Trim();
                    if(value == "")
                    {
                        throw new ArgumentException(
                            "Waciwo LastName nie moe by pusta.", nameof(value));
                    }
                    else
                    {
                        _LastName = value;
                    }
                }
            }
        }
        private string _LastName;

        // Waciwo FirstName
        public string FirstName
        {
            get
            {
                return _FirstName;
            }
            set
            {
                // Sprawdzanie poprawnoci w trakcie przypisywania wartoci waciwoci FirstName.
                if (value == null)
                {
                    // Zgaszanie bdu
                    throw new ArgumentNullException("value");
                }
                else
                {
                    // Usuwanie odstpw wok nowego imienia.
                    value = value.Trim();
                    if(value == "")
                    {
                        throw new ArgumentException(
                            "Waciwo FirstName nie moe by pusta.", "value");
                    }
                    else
                    {
                        _FirstName = value;
                    }
                }
            }
        }
        private string _FirstName;
    }
}
