﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter07.Listing07_12
{
    using Listing07_09;

    interface IDistributedSettingsProvider : ISettingsProvider
    {
        /// <summary>
        /// Pobiera ustawienia dla określonej maszyny.
        /// </summary>
        /// <param name="machineName">
        /// Nazwa maszyny, której dotyczą ustawienia.</param>
        /// <param name="name">Nazwa ustawienia.</param>
        /// <param name="defaultValue">
        /// Wartość zwracana, gdy nie można znaleźć danego ustawienia.</param>
        /// <returns>Określone ustawienie.</returns>
        string GetSetting(
            string machineName, string name, string defaultValue);

        /// <summary>
        /// Ustawianie ustawienia dla konkretnej maszyny.
        /// </summary>
        /// <param name="machineName">
        /// Nazwa maszyny, której dotyczy ustawienie.</param>
        /// <param name="name">Nazwa ustawienia.</param>
        /// <param name="value">Zapisywana wartość.</param>
        /// <returns>Określone ustawienie.</returns>
        void SetSetting(
            string machineName, string name, string value);
    }
}
