﻿namespace AddisonWesley.Michaelis.EssentialCSharp.AppendixD.ListingD_02
{
    using System;
    using System.Threading;

    class UsingSystemThreadingTimer
    {
        private static int _Count = 0;
        private static readonly AutoResetEvent _ResetEvent =
            new AutoResetEvent(false);
        private static int _AlarmThreadId;

        public static void Main()
        {
            // Timer(callback, state, dueTime, period)
            using(Timer timer = new Timer(Alarm, null, 0, 1000))
            {
                // Oczekiwanie na zgłoszenie alarmu po raz 10.
                _ResetEvent.WaitOne();
            }

            // Sprawdzanie, czy wątek uruchamiający alarm 
            // różni się od wątku wykonującego metodę Main.
            if (_AlarmThreadId ==
                Thread.CurrentThread.ManagedThreadId)
            {
                throw new ApplicationException(
                    "Identyfikatory wątków są takie same.");
            }
            if(_Count < 9)
            {
                throw new ApplicationException(" _Count < 9");
            };

            Console.WriteLine(
                "(ID wątku z alarmem) {0} != {1} (ID wątku z metodą Main)",
                _AlarmThreadId,
                Thread.CurrentThread.ManagedThreadId);
            Console.WriteLine("Ostateczna wartość licznika = {0}", _Count);
        }

        static void Alarm(object state)
        {
            _Count++;

            Console.WriteLine("{0}:- {1}",
                DateTime.Now.ToString("T"),
                _Count);

            if(_Count >= 9)
            {
                _AlarmThreadId =
                    Thread.CurrentThread.ManagedThreadId;
                _ResetEvent.Set();
            }
        }
    }
}
