﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter19.Listing19_12
{
    using System;
    using System.Threading;

    class Program
    {
        [ThreadStatic]
        static double _Count = 0.01134;
        public static double Count
        {
            get { return Program._Count; }
            set { Program._Count = value; }
        }

        public static void Main()
        {
            Thread thread = new Thread(Decrement);
            thread.Start();

            // Inkrementacja
            for(int i = 0; i < short.MaxValue; i++)
            {
                Count++;
            }

            thread.Join();
            Console.WriteLine("Count w metodzie Main = {0}", Count);
        }

        static void Decrement()
        {
            for(int i = 0; i < short.MaxValue; i++)
            {
                Count--;
            }
            Console.WriteLine("Count w metodzie Decrement = {0}", Count);
        }
    }
}
