﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter07.Listing07_03
{
    using System;
    using Listing07_02;

    public class Contact : PdaItem, IListable, IComparable
    {
        // ...
        public Contact(string name)
            : base(name)
        {
        }

        #region Składowe z interfejsu IComparable
        /// <summary>
        /// 
        /// </summary>
        /// <param name="obj"></param>
        /// <returns>
        /// Mniejsza niż zero     Obiekt this jest mniejszy niż obj. 
        /// Zero                  Obiekt this jest równy obj. 
        /// Większa niż zero      Obiekt this jest większy niż obj. 
        /// </returns>
        public int CompareTo(object obj)
        {
            int result;
            Contact contact = obj as Contact;

            if(obj == null)
            {
                // Obiekt this jest większy niż obj. 
                result = 1;
            }
            else if(obj.GetType() != typeof(Contact))
            {
                // Zastosuj w komunikacie operator nameof z wersji C# 6.0,
                // aby zapewnić spójność nazwy typu.
                throw new ArgumentException(
                    $"Parametr nie jest typu { nameof(Contact) }",
                    nameof(obj));
            }
            else if(Contact.ReferenceEquals(this, obj))
            {
                result = 0;
            }
            else
            {
                result = LastName.CompareTo(contact.LastName);
                if(result == 0)
                {
                    result = FirstName.CompareTo(contact.FirstName);
                }
            }
            return result;
        }
        #endregion

        #region Składowe z interfejsu IListable
        string[] IListable.ColumnValues
        {
            get
            {
                return new string[] 
                {
                    FirstName,
                    LastName,
                    Phone,
                    Address
                };
            }
        }
        #endregion

        protected string LastName { get; set; }
        protected string FirstName { get; set; }
        protected string Phone { get; set; }
        protected string Address { get; set; }
    }
}
