﻿namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter05.Listing05_44
{
    using System;

    class CommonGuid
    {
        public static readonly Guid ComIUnknownGuid =
            new Guid("00000000-0000-0000-C000-000000000046");
        public static readonly Guid ComIClassFactoryGuid =
            new Guid("00000001-0000-0000-C000-000000000046");
        public static readonly Guid ComIDispatchGuid =
            new Guid("00020400-0000-0000-C000-000000000046");
        public static readonly Guid ComITypeInfoGuid =
            new Guid("00020401-0000-0000-C000-000000000046");
        // ...
    }

    class Program
    {
        public void Main()
        {
            // Uwaga: board.Cells nie wymaga inicjowania.
            TicTacToeBoard board = new TicTacToeBoard();
            Console.WriteLine(board.Cells);
        }
    }


    class TicTacToeBoard
    {
        // Ustawianie elementów tablic z posunięciami obu graczy na wartość false.
        //    |   |          |   |
        // ---+---+---    ---+---+---
        //    |   |          |   |   
        // ---+---+---    ---+---+---
        //    |   |          |   |   
        // Gracz 1 - X   Gracz 2 - O
        public bool[,,] Cells { get; } = new bool[2, 3, 3];

        // Błąd: nie można przypisać wartości do właściwości Cells,
        // ponieważ jest ona przeznaczona tylko do odczytu.
        // public void SetCells(bool[,,] value) =>
        //         _Cells = new bool[2, 3, 3];

        // ...
    }

    class TicTacToeBoardPreCSharp5
    {
        public TicTacToeBoardPreCSharp5()
        {
            // Ustawianie elementów tablic z posunięciami obu graczy na wartość false.
            //    |   |
            // ---+---+---
            //    |   |   
            // ---+---+---
            //    |   |   
            _Cells = new bool[2, 3, 3];
        }

        private readonly bool[,,] _Cells;

        public bool[,,] Cells
        {
            get { return _Cells; }
        }

        // Błąd: nie można w dowolnym miejscu przypisać wartości 
        // do pola przeznaczonego tylko do odczytu (jest to dozwolone
        // tylko w konstruktorze i w inicjatorze zmiennej)
        // public void SetCells(bool[,,] value) =>
        //         _Cells = new bool[2, 3, 3];

        // ...
    }

}
