#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/mman.h>

#define SPC_SMC_START_BLOCK(label)  void label(void) {  }
#define SPC_SMC_END_BLOCK(label)    void _##label(void) {  }
#define SPC_SMC_BLOCK_LEN(label)    (int)_##label - (int)label
#define SPC_SMC_BLOCK_ADDR(label)   (unsigned char *)label
#define SPC_SMC_START_KEY(label)    void key_##label(void) { }
#define SPC_SMC_END_KEY(label)      void _key_##label(void) { }
#define SPC_SMC_KEY_LEN(label)      (int)_key_##label - (int)key_##label
#define SPC_SMC_KEY_ADDR(label)     (unsigned char *)key_##label
#define SPC_SMC_OFFSET(label)       (long)label - (long)_start

extern void _start(void);

/* zwraca liczb szyfrowanych bajtw */
int spc_smc_decrypt(unsigned char *buf, int buf_len, unsigned char *key, int key_len) {
  RC4_CTX ctx;

  RC4_set_key(&ctx, key_len, key);

  /* UWAGA: wikszo segmentw kodu posiada uprawnienia tylko do odczytu, tak wic
   * musi zosta zmodyfikowana, tak aby mona byo zapisywa do bufora
   */
  if (mprotect(buf, buf_len, PROT_WRITE | PROT_READ | PROT_EXEC)) {
    fprintf(stderr, "mprotect: %s\n", strerror(errno));
    return(0);
  }

  /* deszyfrowanie bufora */
  RC4(&ctx, buf_len, buf, buf);

  /* przywrcenie oryginalnych uprawnie dostpu do pamici */
  mprotect(buf, buf_len, PROT_READ | PROT_EXEC);

  return(buf_len);
}

