#include <stdio.h>

/* uwaga: warto "crc32_stored" naley zastpi prawdziw sum kontroln! */
asm(".long 0xCEFAEDFE \n"   /* wyszukanie znacznikw 0xFEEDFACE */
    "crc32_stored:    \n"
    ".long 0xFFFFFFFF \n"   /* ten obszar naley zmieni w pliku binarnym! */
    ".long 0xCEFAEDFE \n"   /* znacznik kocowy */
);

CRC_START_BLOCK(test)
int test_routine(int a) {
  while (a < 12) a = (a - (a * 3)) + 1;
  return a;
}
CRC_END_BLOCK( test )

int main(int argc, char *argv[]) {
  unsigned long crc;

  crc = crc32_calc(CRC_BLOCK_ADDR(test), CRC_BLOCK_LEN(test));
#ifdef TEST_BUILD
  /* Ponisza funkcja printf() wywietla warto CRC, ktra musi zosta zachowana
   * w programie. Funkcj naley usun oraz zrekompilowa program przed rozpoczciem
   * jego rozprowadzania.
   */
  printf("CRC is %08X\n", crc);
#else
  if (crc != crc32_stored) {
    printf("Suma kontrolna CRC32 %#08X nie odpowiada %#08X\n", crc, crc32_stored);
    return 1;
  }
  printf("Suma kontrolna CRC32 %#08X jest poprawna\n", crc);
#endif
  return 0;
}

