void spc_init_server(spc_ssock_t *ctx, unsigned char *key, size_t klen,  int fd) {
  if (klen != 16 && klen != 24 && klen != 32) abort();

  /* naley pamita, e funckja cwc_init() czyci przekazany klucz! */
  cwc_init(&(ctx->cwc), key, klen * 8);

  /* Musimy poczeka na losowy fragment identyfikatora jednorazowego od klienta.
   * Fragment licznika mona zainicjalizowa wartoci zero. Element wyrniajcy 
   * ustawiamy na warto SPC_SERVER_LACKS_NONCE, dziki czemu bdziemy wiedzie,
   * e naley skopiowa losowy fragment identyfikatora jednorazowego w momencie
   * otrzymania komunikatu.
   */
  ctx->nonce[0] = SPC_SERVER_LACKS_NONCE;
  memset(ctx->nonce + SPC_CTR_IX, 0, SPC_CTR_LEN);
  ctx->fd = fd;
}

