int spc_remember_key(char *filename, char *ipnum, EVP_PKEY *key) {
  int   keytype, result = 0;
  char  *keydata;
  FILE  *fp = 0;

  keytype = get_keydata(key, &keydata);
  if (keytype == EVP_PKEY_NONE || !keydata) goto end;
  if (!(fp = fopen(filename, "a"))) goto end;
  fprintf(fp, "%s %d %s\n", ipnum, keytype, keydata);
  result = 1;

end:
  if (keydata) free(keydata);
  if (fp) fclose(fp);
  return result;
}

int spc_accept_key(char *filename, char *ipnum, EVP_PKEY *key) {
  int   result;
  char  answer[80];

  result = spc_lookup_key(filename, ipnum, key);
  if (result == 1) return 1;
  if (result == -1) {
    for (;;) {
      printf("POWANY BD! Od serwera otrzymano inny klucz o tego, ktry "
              "%s\njest zapisany. Czy kontynuowa dziaania? ", ipnum);
      if (!fgets(answer, sizeof(answer), stdin)) continue;
      if (answer[0] == 'Y' || answer[0] == 'y') return 1;
      if (answer[0] == 'N' || answer[0] == 'n') return 0;
    }
  }

  for (;;) {
    printf("UWAGA! Serwer %s przedstawi klucz, o ktrym nic nie wiadomo\n.  "
           "Chcesz ten klucz od[r]zuci, za[a]kceptowa i zapamita, czy\n"
           "pozwoli na jego uycie tylk[o] ten jeden raz? ", ipnum);
    if (!fgets(answer, sizeof(answer), stdin)) continue;       
    if (answer[0] == 'r' || answer[0] == 'R') return 0;
    if (answer[0] == 'o' || answer[0] == 'O') return 1;
    if (answer[0] == 'a' || answer[0] == 'A') break;
  }

  if (!spc_remember_key(filename, ipnum, key))
    printf("Bd zapamitywania klucza!  Zostanie on zaakceptowany tylko "
           "ten jeden raz.\n");
  return 1;
}
