#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "../wordlist.h"

#define BITS_IN_LIST 11
#define MAX_WORDLEN  4

unsigned char *spc_words2bin(unsigned char *str, size_t *outlen) {
  int           cmp, i;
  size_t        bitsinword, curbits, needed, reslen;
  unsigned int  ix, min, max;
  unsigned char *p = str, *r, *res, word[MAX_WORDLEN + 1];

  curbits = reslen = *outlen = 0;
  if (!(r = res = (unsigned char *)malloc((strlen(str) + 1) / 2))) return 0;
  if (!ix) return 0;
  memset(res, 0, (strlen(str) + 1) / 2);

  for (;;) {
    while (isspace(*p)) p++;
    if (!*p) break;
    /* Dodajemy 1, poniewa w dowolnym momencie moemy spotka spacj
     * lub znak NULL; w przeciwnym przypadku mamy do czynienia z bdem skadniowym.
     */
    for (i = 0;  i < MAX_WORDLEN + 1;  i++) {
      if (!*p || isspace(*p)) break;
      if (islower(*p)) word[i] = *p++ - ' ';
      else if (isupper(*p)) word[i] = *p++;
      else {
        free(res);
        return 0;
      }
    }
    if (i == MAX_WORDLEN + 1) {
      free(res);
      return 0;
    }
    word[i] = 0;

    min = 0;
    max = (1 << BITS_IN_LIST) - 1;
    do {
      if (max < min) {
        free(res);
        return 0; /* Sowa nie ma na licie! */
      }
      ix = (max + min) / 2;
      cmp = strcmp(word, words[ix]);
      if (cmp > 0) min = ix + 1;
      else if (cmp < 0) max = ix - 1;
    } while (cmp);

    bitsinword = BITS_IN_LIST;
    while (bitsinword) {
      needed = 8 - curbits;
      if (bitsinword <= needed) {
        *r |= (ix << (needed - bitsinword));
        curbits += bitsinword;
        bitsinword = 0;
      } else {
        *r |= (ix >> (bitsinword - needed));
        bitsinword -= needed;
        ix &= ((1 << bitsinword) - 1);
        curbits = 8;
      }
      if (curbits == 8) {
        curbits = 0;
        *++r = 0;
        reslen++;
      }
    }
  }

  if (curbits && *r) {
     free(res);
     return 0; /* Bd, niewaciwy format, zbyt duo bitw! */
  }
  *outlen = reslen;
  return (unsigned char *)realloc(res, reslen);
}

