#include <windows.h>

BOOL RemoveBackupAndRestorePrivileges(VOID) {
  BOOL              bResult;
  HANDLE            hProcess, hProcessToken;
  PTOKEN_PRIVILEGES pNewState;

  /* Przydziel pami dla bufora TOKEN_PRIVILEGES, w ktrym bd przechowywane
   * informacje o zmianach uprawnie. W programie bd stosowane dwa
   * uprawnienia, musimy si wic upewni, e istnieje miejsce w pamici 
   * dla dwch elementw LUID_AND_ATTRIBUTES w polu Privileges struktury
   * TOKEN_PRIVILEGES.
   */

  pNewState = (PTOKEN_PRIVILEGES)LocalAlloc(LMEM_FIXED, sizeof(TOKEN_PRIVILEGES) +
                                            (sizeof(LUID_AND_ATTRIBUTES) * 2));
  if (!pNewState) return FALSE;

  /* Dodaj dwa uprawnienia, ktre zostan usunite (przeniesione do bufora) */
  pNewState->PrivilegeCount = 2;
  if (!LookupPrivilegeValue(0, SE_BACKUP_NAME, &pNewState->Privileges[0].Luid) ||
      !LookupPrivilegeValue(0, SE_RESTORE_NAME, &pNewState->Privileges[1].Luid)) {
    LocalFree(pNewState);
    return FALSE;
  }
  pNewState->Privileges[0].Attributes = SE_PRIVILEGE_REMOVED;
  pNewState->Privileges[1].Attributes = SE_PRIVILEGE_REMOVED;

  /* Uzyskaj uchwyt do gwnego tokenu danego procesu. Zadaj dostpu
   * TOKEN_ADJUST_PRIVILEGES, aby mona byo dostosowywa uprawnienia. Nie damy
   * adnych innych uprawnie, poniewa bdziemy te uprawnienia usuwali, a wic
   * nie bdzie nas interesowa poprzedni stan. Do uzyskania informacji o wczeniejszym
   * byby wymagany dostp TOKEN_OUERY.
   */

  hProcess = GetCurrentProcess();
  if (!OpenProcessToken(hProcess, TOKEN_ADJUST_PRIVILEGES, &hProcessToken)) {
    LocalFree(pNewState);
    return FALSE;
  }

  /* Ustawiamy uprawnienia  przekazujemy warto FALSE dla argumentu DisableAllPrivileges,
   * aby zamiast niego zosta wykorzystany argument NewState.  Nie damy informacji dotyczcych
   * poprzedniego stanu tokenu  w ostatnich trzech argumentach przekazujemy warto
   * 0.
   */

  bResult = AdjustTokenPrivileges(hProcessToken, FALSE, pNewState, 0, 0, 0);

  /* Czyci rodowisko i zwraca informacje o sukcesie lub niepowodzeniu operacji
   * modyfikacji.
   */

  CloseHandle(hProcessToken);
  LocalFree(pNewState);
  return bResult;
}
