/* x oraz y s typu char, zwracana warto typu short */
/* x jest na pozycji 0, y na pozycji 1 */
#define MERGE_CHAR(x, y)    (((y) << 8 ) | (x))

/* s jest typu short, za c jest pozycj -- 0 lub 1 */
#define GET_CHAR(s, c)      (char)(((s) >> (8 * (c))) & 0x00FF)

/* s jest typu short, za c jest pozycj i val jest wartoci typu char */
#define SET_CHAR(s, c, val) (((s) & (0xFF00 >> (8 * (c)))) | ((val) << (8 * (c))))

/* x oraz y s typu short, zwracana warto typu int */
/* x jest na pozycji 0, y na pozycji 1 */
#define MERGE_SHORT(x, y)   (((y) << 16 ) | (x))

/* i jest typu int, za s jest pozycj -- 0 lub 1 */
#define GET_SHORT(i, s)     (short)(((i) >> (16 * (s))) & 0x0FFFF)

/* i jest typu int, za s jest pozycj i val jest wartoci typu short */
#define SET_SHORT(i, s, val) (((i) & (0xFFFF0000 >> (16 * (s)))) | \
                             ((val) << (16 * (s))))

