/* keylen to warto okrelana w bajtach. Naley zauway, e w przypadku
 * wystpienia bdw wywoywana jest funkcja abort(), cho w realnej sytuacji
 * zwykle podane bdzie przeprowadzenie obsugi bdw, co omwiono w
 * recepturze 13.1. W kadym bd razie informacja o bdzie nigdy nie jest
 * przekazywana drugiej stronie; nastpuje po prostu odrzucenie poczenia
 * (poprzez wyjcie). W przypadku poprawnego zamykania przesyany jest komunikat.
 */

void spc_init_client(spc_ssock_t *ctx, unsigned char *key, size_t klen, int fd) {
  if (klen != 16 && klen != 24 && klen != 32) abort();

  /* Trzeba pamita, e funkcja cwc_init() czyci przekazywany klucz! */
  cwc_init(&(ctx->cwc), key, klen * 8);

  /* Wybieramy 5 losowych bajtw i umieszczamy pierwszy na pozycji nonce[1].
   * Uywamy interfejsu API z receptury 11.2.
   */
  spc_rand(ctx->nonce + SPC_IV_IX, SPC_IV_LEN);

  /* Ustawiamy 5 przeciwlegych bajtw na warto 0, przez co okrelamy, e
   * nie przesalimy adnego komunikatu. */
  memset(ctx->nonce + SPC_CTR_IX, 0, SPC_CTR_LEN);
  ctx->fd = fd;

  /* Ponisza warto zawsze okrela ostatni osob, do ktrej przesalimy
   * komunikat. Jeeli klient przele komunikat, a ten zostanie przesany do
   * SPC_CLIENT_DISTINGUISHER, wwczas wiemy, e wystpi bd.
   */
  ctx->nonce[0] = SPC_SERVER_DISTINGUISHER;
}

