#include <openssl/bn.h>

typedef struct {
  BIGNUM *n;
  BIGNUM *g; /* uywamy wartoci BIGNUM, mimo e g jest zwykle mae. */
  BIGNUM *private_value;
  BIGNUM *public_value;
} DH_CTX;

/* W przypadku poniszej funkcji zakadamy, e wszystkie wartoci BIGNUM maj ju
 * przydzielon pami oraz e n i g zostay ju wybrane i poprawnie zainicjalizowane.
 * Po udanym zakoczeniu jej dziaania naley uy funkcji BN_bn2bin() wzgldem
 * pola ctx->public_value w celu otrzymania reprezentacji binarnej przesyanej
 * sieci. W recepturze 7.4 mona znale wicej informacji na temat konwersji
 * midzy formatem BN a binarnym.
 */
int DH_generate_keys(DH_CTX *ctx) {
  BN_CTX *tmp_ctx;

  if (!(tmp_ctx = BN_CTX_new())) return 0;
  if (!BN_rand_range(ctx->private_value, ctx->n)) {
    BN_CTX_free(tmp_ctx);
    return 0;
  }
  if (!BN_mod_exp(ctx->public_value, ctx->g, ctx->private_value, ctx->n, tmp_ctx)) {
    BN_CTX_free(tmp_ctx);
    return 0;
  }
  BN_CTX_free(tmp_ctx);
  return 1;
}
